/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	VillagerState
**
** DESCRIPTION:	Villager state
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef VILLAGER_STATE_H
#define VILLAGER_STATE_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
class CVillager;

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

enum ECauseOfDeath
{
	eCauseOfDeath_Unknown = -1,

	eCauseOfDeath_Disease,
	eCauseOfDeath_Starvation,
	eCauseOfDeath_OldAge,
	eCauseOfDeath_VocationalInjury,
	eCauseOfDeath_ActOfNature,

	eCauseOfDeath_NumberOf
};

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CVillagerState
{
private:

	//class data
	unsigned long	m_uiSecondsAccumulated;
	unsigned long	m_uiLastTimeChecked;
	int				m_iAgesChecked;
	int				m_iHealth;
	ECauseOfDeath	m_eCauseOfDeath;
	bool			m_iIsChief;
	int				m_iChiefStartTime;
	bool			m_iIsChosenOne;
	bool			m_bHasDisease;
	int				m_iPregnancyStartTime;
	int				m_iNumBabies;
	bool			m_bIsTotem;
	int				m_iTotemX;
	int				m_iTotemY;
	int				m_iPreDisposition;
	bool			m_bWasAwardedTotem;
	int				m_iJumpHeight;

	//class methods
	//setup
	public:		CVillagerState();
	public:		void Copy(CVillagerState &State);
	public:		void Reset(const int iAge);

	//process
	public:		void Update(CVillager &Villager);

	//access
	public:		void SetIsTotem(const bool bIsTotem) { m_bIsTotem = bIsTotem; }
	public:		const bool IsTotem() const { return m_bIsTotem; }
	public:		void SetAwardedTotem(const bool bWasAwardedTotem) { m_bWasAwardedTotem = bWasAwardedTotem; }
	public:		const bool IsCaringForBaby() const { return m_iPregnancyStartTime != 0; }
	public:		const bool IsAlive() const { return m_iHealth > 0; }
	public:		const bool IsDead() const { return m_iHealth <= 0; }

	public: 	const ECauseOfDeath CauseOfDeath() const {return m_eCauseOfDeath;}

	public:		const bool IsChief() const { return m_iIsChief; }
	public:		void SetChiefFlag(const bool bIsChief) { m_iIsChief = bIsChief; m_iChiefStartTime = m_iAgesChecked; }
	public:		const bool IsChosenOne() const { return m_iIsChosenOne; }
	public:		void SetChosenOne(const bool bIsChosenOne) { m_iIsChosenOne = bIsChosenOne; }
	
	public:		void SetPregnancyStartTime(const int iTime) { m_iPregnancyStartTime = iTime; }
	public:		const int PregnancyStartTime() const { return m_iPregnancyStartTime; }

	public:		void SetDisease(const int iDisease) { m_bHasDisease = (iDisease != 0); }
	public:		const bool HasDisease() const { return m_bHasDisease != 0; }
	public:		const bool IsHealthy() const { return m_bHasDisease == 0; }

	public:		void SetPreDisposition(const int preDisposition) { m_iPreDisposition = preDisposition; }
	public:		const int PreDisposition() const { return m_iPreDisposition; }

	public:		void SetAgesChecked(const int iAgesChecked) { m_iAgesChecked = iAgesChecked; }
	public:		void AdjustAgesChecked(const int iAdj) { m_iAgesChecked += iAdj; }
	public:		const int AgesChecked() const { return m_iAgesChecked; }

	public:		void SetLastTimeChecked(const unsigned long uiTime) { m_uiLastTimeChecked = uiTime; }
	public:		const unsigned long LastTimeChecked() const { return m_uiLastTimeChecked; }

	public:		void SetSecondsAccumulated(const unsigned long uiSeconds) { m_uiSecondsAccumulated = uiSeconds; }
	public:		void IncrementSecondsAccumulated(const unsigned long uiSeconds) { m_uiSecondsAccumulated += uiSeconds; }
	public:		const unsigned long SecondsAccumulated() { return m_uiSecondsAccumulated; }

	public:		void SetHealth(const int iHealth, const ECauseOfDeath eCauseOfDeath = eCauseOfDeath_Unknown);
	public:		void AdjustHealth(const int iAdj, const ECauseOfDeath eCauseOfDeath = eCauseOfDeath_Unknown);
	public:		const int Health() const { return m_iHealth; }

	public:		void SetBabies(const int iBabies) { m_iNumBabies = iBabies; }
	public:		const int Babies() const { return m_iNumBabies; }

	public:		void SetTotemX(const int iTotemX) { m_iTotemX = iTotemX; }
	public:		const int TotemX() const { return m_iTotemX; }
	public:		void SetTotemY(const int iTotemY) { m_iTotemY = iTotemY; }
	public:		const int TotemY() const { return m_iTotemY; }

	public:		void SetJumpHeight(const int iJumpHeight) { m_iJumpHeight = iJumpHeight; }
	public:		const int JumpHeight() const { return m_iJumpHeight; }
};

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/